/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.mainMenu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuButton;

public class MenuSmallButton
extends MenuButton {
    private MenuButton.ClickResult result;
    private String label;
    private Hitbox hb;
    private Color tint = Color.WHITE.cpy();
    private int index;
    private boolean isDisabled = false;
    private float x = 0.0f;
    private float targetX = 0.0f;

    public MenuSmallButton(MenuButton.ClickResult r, int index) {
        super(r, index);
        this.result = r;
        this.index = index;
        this.setLabel();
        this.hb = new Hitbox(FontHelper.getSmartWidth(FontHelper.menuButtonFont, this.label, 9999.0f, 1.0f) + 100.0f * Settings.scale, SPACE_Y);
        this.hb.move(this.hb.width / 2.0f + 75.0f * Settings.scale, START_Y + (float)index * SPACE_Y);
    }

    private void setLabel() {
        switch (this.result) {
            case CARDS: {
                this.label = TEXT[0];
                break;
            }
            case CHAR_SELECT: {
                this.label = TEXT[1];
                break;
            }
            case DAILY: {
                this.label = TEXT[2];
                break;
            }
            case RELICS: {
                this.label = TEXT[3];
                break;
            }
            case RESUME_GAME: {
                this.label = TEXT[4];
                break;
            }
            case LEADERBOARD: {
                this.label = TEXT[5];
                break;
            }
            case STATS: {
                this.label = TEXT[6];
                break;
            }
            case CREDITS: {
                this.label = TEXT[7];
                break;
            }
            case QUIT: {
                this.label = TEXT[8];
                break;
            }
            case PATCH_NOTES: {
                this.label = TEXT[9];
                break;
            }
            default: {
                this.label = "ERROR";
            }
        }
    }

    @Override
    public void update() {
        if (CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.MAIN_MENU && CardCrawlGame.mainMenuScreen.bg.slider < 0.5f) {
            this.hb.update();
        }
        this.x = MathHelper.uiLerpSnap(this.x, this.targetX);
        if (this.hb.justHovered) {
            CardCrawlGame.sound.playV("UI_HOVER", 0.75f);
        }
        if (this.hb.hovered) {
            this.targetX = 25.0f * Settings.scale;
            if (InputHelper.justClickedLeft) {
                CardCrawlGame.sound.playA("UI_CLICK_1", -0.1f);
                this.hb.clickStarted = true;
            }
            this.tint = Color.WHITE.cpy();
        } else if (CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.MAIN_MENU) {
            this.targetX = 0.0f;
            this.tint.g = this.tint.r = MathHelper.fadeLerpSnap(this.tint.r, 0.3f);
            this.tint.b = this.tint.r;
        }
        if (this.hb.clicked) {
            this.hb.clicked = false;
            this.buttonEffect();
            CardCrawlGame.mainMenuScreen.hideMenuButtons();
        }
    }

    @Override
    public void hide() {
        this.hb.hovered = false;
        this.targetX = -650.0f * Settings.scale;
    }

    @Override
    public void buttonEffect() {
        switch (this.result) {
            case CARDS: {
                CardCrawlGame.mainMenuScreen.cardLibraryScreen.open();
                CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.CARD_LIBRARY;
                break;
            }
            case CHAR_SELECT: {
                CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.CHAR_SELECT;
                break;
            }
            case DAILY: {
                break;
            }
            case LEADERBOARD: {
                break;
            }
            case RELICS: {
                CardCrawlGame.mainMenuScreen.relicScreen.open();
                CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.RELIC_VIEW;
                break;
            }
            case STATS: {
                CardCrawlGame.mainMenuScreen.statsScreen.open();
                CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.STATS;
                break;
            }
            case PATCH_NOTES: {
                CardCrawlGame.mainMenuScreen.patchNotesScreen.open();
                break;
            }
            case CREDITS: {
                CardCrawlGame.mainMenuScreen.creditsScreen.open();
                CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.CREDITS;
                break;
            }
            case QUIT: {
                Gdx.app.exit();
                break;
            }
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        float lerper = Interpolation.circleIn.apply(CardCrawlGame.mainMenuScreen.bg.slider);
        float sliderX = -1000.0f * Settings.scale * lerper;
        sliderX -= (float)this.index * 250.0f * Settings.scale * lerper;
        if (this.hb.hovered) {
            FontHelper.renderSmartText(sb, FontHelper.menuButtonFont, this.label, this.x + FONT_X + sliderX, this.hb.cY + FONT_OFFSET_Y, 9999.0f, 1.0f, Settings.GOLD_COLOR);
        } else if (this.isDisabled) {
            FontHelper.renderSmartText(sb, FontHelper.menuButtonFont, this.label, this.x + FONT_X + sliderX, this.hb.cY + FONT_OFFSET_Y, 9999.0f, 1.0f, Settings.RED_TEXT_COLOR);
        } else {
            FontHelper.renderSmartText(sb, FontHelper.menuButtonFont, this.label, this.x + FONT_X + sliderX, this.hb.cY + FONT_OFFSET_Y, 9999.0f, 1.0f, Settings.CREAM_COLOR);
        }
        this.hb.render(sb);
    }
}

